/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.AbortReply;
import com.ibm.hwmca.fw.rbf.impl.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.rbf.impl.RbfMsg;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.util.Trace;

class AbortMsg
implements RbfMsg {
    private static final String TRACE_MASKT = "XRBFAMST";
    private static final String TRACE_MASKF = "XRBFAMSF";
    private static final String TRACE_MASKD = "XRBFAMSD";
    private static final long serialVersionUID = -1286872868231039444L;
    private RbfRequestId requestId;
    private int status;
    static final int STATUS_NOT_NEEDED = 0;
    static final int STATUS_CANCELED = 4;
    static final int STATUS_INTERNAL_ERROR = 8;
    static final int STATUS_APPLICATION_ERROR = 12;

    AbortMsg(RbfRequestId requestId, int status) {
        if (requestId == null) {
            throw new IllegalArgumentException("Null request identifier specified");
        }
        if (!this.isValidStatus(status)) {
            throw new IllegalArgumentException("Invalid status specified");
        }
        this.requestId = requestId;
        this.status = status;
        Trace.trace(TRACE_MASKT, "<> " + this.toString());
    }

    boolean isValidStatus(int status) {
        switch (status) {
            case 0: {
                return true;
            }
            case 4: {
                return true;
            }
            case 8: {
                return true;
            }
            case 12: {
                return true;
            }
        }
        return false;
    }

    RbfRequestId getRequestId() {
        return this.requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbfReply process(MachineId sender2, int protocol) {
        AbortReply reply;
        block10: {
            Trace.trace(TRACE_MASKT, "-> process()");
            reply = null;
            try {
                RequestHandlingManager rhMgr = RequestHandlingManager.getRequestHandlingManager();
                RbfRequest request = rhMgr.getRequest(this.requestId);
                if (request != null) {
                    RequestTrackingData trackingData;
                    RequestTrackingData requestTrackingData = trackingData = request.getTrackingData();
                    synchronized (requestTrackingData) {
                        if (this.status == 4) {
                            if (trackingData.isStateChangeValid(trackingData.state, 12)) {
                                trackingData.state = 12;
                                trackingData.canceled = true;
                            }
                        } else if (trackingData.isStateChangeValid(trackingData.state, 6)) {
                            trackingData.state = 6;
                        }
                    }
                    reply = rhMgr.terminateHandling(this.requestId) ? new AbortReply(this.requestId, 0) : new AbortReply(this.requestId, 4);
                    break block10;
                }
                reply = new AbortReply(this.requestId, 0);
            }
            catch (PersistenceNotInitializedException pnie) {
                reply = new AbortReply(this.requestId, 0);
            }
        }
        Trace.trace(TRACE_MASKT, "<- process()");
        return reply;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[AbortMsg: reqId=" + this.requestId + ", status=" + this.status + "]");
        return sb.toString();
    }
}

